<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-800"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
      <a href="<?= base_url('admin/tahunajaran/new'); ?>" class="btn btn-primary mb-4">Tambah <?= $title; ?></a>
         <div class="table-responsive">
            <table class="m-0 font-weight-bold table">
               <thead>
                  <tr>
                     <th>No</th>
                     <th>Tahun</th>
                     <th>Status</th>
                     <th>Aksi</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $no = 1;
                  foreach ($tahun as $t) : ?>
                     <tr>
                        <td><?= $no++; ?></td>
                        <td><?= $t['tahun_ajaran']; ?></td>
                        <td><?= ($t['status'] == 0 ? 'Tidak Aktif' : 'Sedang Aktif'); ?>
                           <?php if ($t['status'] == null || $t['status'] == 0) : ?>
                              <a href="<?= base_url('/admin/tahunajaran/active/' . $t['id']); ?>" class="btn btn-warning btn-sm text-dark"><i class="fas fa-check"></i> Aktifkan</a>
                           <?php else : ?>
                              <span class="badge badge-success"><i class="fas fa-check"></i></span>
                           <?php endif; ?>
                        </td>
                        <td>
                           <a href="<?= base_url('admin/tahunajaran/edit/' . $t['id']) ?>" class="btn btn-primary">Edit</a>
                           <form action="<?= base_url('admin/tahunajaran/delete/'. $t['id']); ?>" method="POST" class="d-inline-block">
                              <?= csrf_field(); ?>
                              <input type="hidden" name="_method" value="DELETE">
                              <button type="submit" class="btn btn-danger text-light" onclick="return confirm('Apakah anda yakin menghapus data ini?')">Hapus</button>
                           </form>
                        </td>
                     </tr>
                  <?php endforeach; ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>