<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/slideshow/create') ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="judul_slide">Judul Slide</label>
                  <input type="text" name="judul_slide" id="judul_slide" class="form-control <?= (validation_show_error('judul_slide') ? "is-invalid" : "") ?>" value="<?= set_value('judul_slide') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('judul_slide') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="deskripsi_slide">Deskripsi Slide</label>
                  <textarea name="deskripsi_slide" id="deskripsi_slide" class="form-control <?= (validation_show_error('deskripsi_slide') ? "is-invalid" : "") ?>" rows="4" value="<?= set_value('deskripsi_slide') ?>"></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('deskripsi_slide') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="foto_slide">Foto <small>(Format .jpg, .jpeg, .png)</small></label>
                  <input type="file" name="foto_slide" id="foto_slide" class="form-control-file <?= (validation_show_error('foto_slide') ? "is-invalid" : "") ?>" onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_slide') ?>
                  </div>
                  <img id='output' class="mt-3 mb-0" style="width: 400px;">
               </div>
               <div class="form-group">
                  <label for="status">Status</label>
                  <select name="status" id="status" class="form-control <?= (validation_show_error('status') ? "is-invalid" : "") ?>">
                     <option value="">-- Pilih Status --</option>
                     <option value="0" <?php if (set_value('status') == '0') echo "selected = 'selected'" ?>>Tidak Aktif</option>
                     <option value="1" <?php if (set_value('status') == '1') echo "selected = 'selected'" ?>>Aktif</option>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('status') ?>
                  </div>
               </div>
               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>