<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddStatusToPpdb extends Migration
{
    public function up()
    {
        // Cek apakah kolom status sudah ada
        $db = \Config\Database::connect();
        $builder = $db->query("SHOW COLUMNS FROM ppdb LIKE 'status'");
        
        if ($builder->getNumRows() == 0) {
            $this->forge->addColumn('ppdb', [
                'status' => [
                    'type' => 'ENUM',
                    'constraint' => ['Pending', 'Diterima', 'Ditolak'],
                    'default' => 'Pending'
                ]
            ]);
        }
    }

    public function down()
    {
        $this->forge->dropColumn('ppdb', 'status');
    }
}
