<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use \App\Models\SlideshowModel;

class Slideshow extends BaseController
{
	protected $slideshowModel;

	public function __construct()
	{
		$this->slideshowModel = new SlideshowModel();
	}

	public function index()
	{
		return view('admin/slideshow/index', [
			'title' => 'Home Slideshow',
			'slideshow' => $this->slideshowModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/slideshow/create', [
			'title' => 'Tambah Gambar Slideshow',
			'validation' => $this->validation,
		]);
	}

	public function create()
	{
		$rules = [
			'judul_slide' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_slide' => [
				'rules'  => 'uploaded[foto_slide]|mime_in[foto_slide,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_slide,jpg,jpeg,png]',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
		}

		try {
			$foto = $this->request->getFile('foto_slide');
			if ($foto->isValid() && !$foto->hasMoved()) {
				$newName = $foto->getRandomName();
				$foto->move('img/slideshow', $newName);
			} else {
				throw new \Exception('File foto tidak valid atau gagal diupload');
			}
			
			$data = [
				'judul_slide' => $this->request->getPost('judul_slide'),
				'deskripsi_slide' => $this->request->getPost('deskripsi_slide'),
				'foto_slide' => $newName,
				'status' => $this->request->getPost('status'),
			];

			$this->slideshowModel->insert($data);
			$this->session->setFlashdata('success', 'Data Slideshow Berhasil Ditambahkan.');
			return redirect()->to('/admin/slideshow');
			
		} catch (\Exception $e) {
			log_message('error', 'Slideshow create error: ' . $e->getMessage());
			$this->session->setFlashdata('error', 'Terjadi kesalahan saat menambah slideshow: ' . $e->getMessage());
			return redirect()->back()->withInput();
		}
	}

	public function edit($id)
	{
		return view('admin/slideshow/edit', [
			'title' => 'Edit Slideshow',
			'slideshow' => $this->slideshowModel->find($id),
			'validation' => $this->validation,
		]);
	}

	public function update($id)
	{
		$rules = [
			'judul_slide' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_slide' => [
				'rules'  => 'mime_in[foto_slide,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_slide,jpg,jpeg,png]',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
		}

		try {
			$foto = $this->request->getFile('foto_slide');
			if ($foto->isValid() && !$foto->hasMoved()) {
				$newName = $foto->getRandomName();
				$foto->move('img/slideshow', $newName);
				
				// Hapus foto lama dengan safety check
				$fotoLama = $this->request->getPost('foto_slide_lama');
				if ($fotoLama && $fotoLama != 'default.jpg' && file_exists('img/slideshow/' . $fotoLama)) {
					unlink('img/slideshow/' . $fotoLama);
				}
			} else {
				$newName = $this->request->getPost('foto_slide_lama');
			}

			$data = [
				'judul_slide' => $this->request->getPost('judul_slide'),
				'deskripsi_slide' => $this->request->getPost('deskripsi_slide'),
				'foto_slide' => $newName,
				'status' => $this->request->getPost('status'),
			];

			$this->slideshowModel->update($id, $data);
			$this->session->setFlashdata('success', 'Data Slideshow Berhasil Diubah.');
			return redirect()->to('/admin/slideshow');
			
		} catch (\Exception $e) {
			log_message('error', 'Slideshow update error: ' . $e->getMessage());
			$this->session->setFlashdata('error', 'Terjadi kesalahan saat mengupdate slideshow: ' . $e->getMessage());
			return redirect()->back()->withInput();
		}
	}

	public function delete($id)
	{
		try {
			$slideshow = $this->slideshowModel->find($id);
			
			if (!$slideshow) {
				$this->session->setFlashdata('error', 'Data slideshow tidak ditemukan.');
				return redirect()->to('/admin/slideshow');
			}
			
			// Hapus file foto dengan safety check
			if ($slideshow['foto_slide'] && $slideshow['foto_slide'] != 'default.jpg' && file_exists('img/slideshow/' . $slideshow['foto_slide'])) {
				unlink('img/slideshow/' . $slideshow['foto_slide']);
			}
			
			$this->slideshowModel->delete($id);
			$this->session->setFlashdata('success', 'Data Slideshow Berhasil Dihapus.');
			return redirect()->to('/admin/slideshow');
			
		} catch (\Exception $e) {
			log_message('error', 'Slideshow delete error: ' . $e->getMessage());
			$this->session->setFlashdata('error', 'Terjadi kesalahan saat menghapus slideshow: ' . $e->getMessage());
			return redirect()->to('/admin/slideshow');
		}
	}

	public function active($id)
	{
		$data = [
			'status' => 1
		];

		$this->slideshowModel->update($id, $data);
		session()->setFlashdata('success', 'Gambar Slideshow Berhasil Diaktifkan.');
		return redirect()->to('/admin/slideshow');
	}
}
