<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\PengaturanwebModel;

class Pengaturanweb extends BaseController
{
	protected $pengaturanModel;

	public function __construct()
	{
		$this->pengaturanModel = new PengaturanwebModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}
		
		return view('admin/pengaturan-web/index', [
			'title' => 'Pengaturan Web Sekolah',
			'pengaturan' => $this->pengaturanModel->first(),
		]);
	}

	public function update($id)
	{
		$logoSekolah = $this->request->getFile('logo_sekolah');
		// $logoAkreditasi = $this->request->getFile('logo_akreditasi');
		// $logoWilayah = $this->request->getFile('logo_wilayah');
		// $logoKabupaten = $this->request->getFile('logo_kabupaten');
		$strukturOrganisasi = $this->request->getFile('struktur_organisasi');
		if ($logoSekolah->isValid()) {
			$name = $logoSekolah->getName();
			$logoSekolahBaru = $logoSekolah->getRandomName();
			$logoSekolah->move('img/pengaturan', $logoSekolahBaru);

			$oldLogo = $this->request->getPost('logo_sekolah_lama');
			$oldPath = 'img/pengaturan/' . $oldLogo;
			if ($oldLogo && file_exists($oldPath)) {
				unlink($oldPath);
			}
		} else {
			$logoSekolahBaru = $this->request->getPost('logo_sekolah_lama');
		}

		// if ($logoAkreditasi->isValid()) {
		// 	$name = $logoAkreditasi->getName();
		// 	$logoAkreditasiBaru = $logoAkreditasi->getRandomName();
		// 	$logoAkreditasi->move('img/pengaturan', $logoAkreditasiBaru);
		// 	unlink('img/pengaturan/' . $this->request->getPost('logo_akreditasi_lama'));
		// } else {
		// 	$logoAkreditasiBaru = $this->request->getPost('logo_akreditasi_lama');
		// }

		// if ($logoWilayah->isValid()) {
		// 	$name = $logoWilayah->getName();
		// 	$logoWilayahBaru = $logoWilayah->getRandomName();
		// 	$logoWilayah->move('img/pengaturan', $logoWilayahBaru);
		// 	unlink('img/pengaturan/' . $this->request->getPost('logo_wilayah_lama'));
		// } else {
		// 	$logoWilayahBaru = $this->request->getPost('logo_wilayah_lama');
		// }

		// if ($logoKabupaten->isValid()) {
		// 	$name = $logoKabupaten->getName();
		// 	$logoKabupatenBaru = $logoKabupaten->getRandomName();
		// 	$logoKabupaten->move('img/pengaturan', $logoKabupatenBaru);
		// 	unlink('img/pengaturan/' . $this->request->getPost('logo_kabupaten_lama'));
		// } else {
		// 	$logoKabupatenBaru = $this->request->getPost('logo_kabupaten_lama');
		// }

		if ($strukturOrganisasi->isValid()) {
			$name = $strukturOrganisasi->getName();
			$strukturOrganisasiBaru = $strukturOrganisasi->getRandomName();
			$strukturOrganisasi->move('img/pengaturan', $strukturOrganisasiBaru);
			//unlink('img/pengaturan/' . $this->request->getPost('struktur_organisasi_lama'));
		} else {
			$strukturOrganisasiBaru = $this->request->getPost('struktur_organisasi_lama');
		}

		$data = [
			'nama_website' => $this->request->getPost('nama_website'),
			'visi' => $this->request->getPost('visi'),
			'misi' => $this->request->getPost('misi'),
			'no_telp' => $this->request->getPost('no_telp'),
			'no_whatsapp' => $this->request->getPost('no_whatsapp'),
			'alamat' => $this->request->getPost('alamat'),
			'logo_sekolah' => $logoSekolahBaru,
			// 'logo_akreditasi' => $logoAkreditasiBaru,
			// 'logo_wilayah' => $logoWilayahBaru,
			// 'logo_kabupaten' => $logoKabupatenBaru,
			'struktur_organisasi' => $strukturOrganisasiBaru,
			'email' => $this->request->getPost('email'),
			// 'facebook' => $this->request->getPost('facebook'),
			// 'twitter' => $this->request->getPost('twitter'),
			// 'instagram' => $this->request->getPost('instagram'),
			'gmaps' => $this->request->getPost('gmaps'),
			'bgcolor_navbar' => $this->request->getPost('color_navbar'),
			'txcolor_navbar' => $this->request->getPost('text_navbar'),
			'bgcolor_footer' => $this->request->getPost('color_footer'),
		];

		$this->pengaturanModel->update($id, $data);
		$this->session->setFlashdata('success', 'Data Pengaturan Website Berhasil Di Update.');
		return redirect()->to('/admin/pengaturanweb');
	}
}
