<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\GaleriModel;

class Galeri extends BaseController
{
	protected $galeriModel;

	public function __construct()
	{
		$this->galeriModel = new GaleriModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}
		
		return view('admin/galeri/index', [
			'title' => 'Galeri',
			'galeri' => $this->galeriModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/galeri/create', [
			'title' => 'Tambah Data Galeri',
			'validation' => $this->validation
		]);
	}

	public function create()
	{
		$rules = [
			'nama_galeri' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_galeri' => [
				'rules'  => 'uploaded[foto_galeri]|mime_in[foto_galeri,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_galeri,jpg,jpeg,png]',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_galeri');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/galeri', $newName);
		}
		$data = [
			'nama_galeri' => $this->request->getPost('nama_galeri'),
			'foto_galeri' => $newName,
		];

		$this->galeriModel->insert($data);
		$this->session->setFlashdata('success', 'Data Galeri Berhasil Ditambahkan.');
		return redirect()->to('/admin/galeri');
	}

	public function edit($id)
	{
		return view('admin/galeri/edit', [
			'title' => 'Edit Data Galeri',
			'galeri' => $this->galeriModel->find($id),
			'validation' => $this->validation
		]);
	}

	public function update($id)
	{
		$rules = [
			'nama_galeri' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_galeri' => [
				'rules'  => 'mime_in[foto_galeri,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_galeri,jpg,jpeg,png]',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_galeri');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/galeri', $newName);
			unlink('img/galeri/' . $this->request->getPost('foto_galeri_lama'));
		} else {
			$newName = $this->request->getPost('foto_galeri_lama');
		}

		$data = [
			'nama_galeri' => $this->request->getPost('nama_galeri'),
			'foto_galeri' => $newName,
		];

		$this->galeriModel->update($id, $data);
		$this->session->setFlashdata('success', 'Data Galeri Berhasil Diubah.');
		return redirect()->to('/admin/galeri');
	}

	public function delete($id)
	{
		$galeri = $this->galeriModel->find($id);
		unlink('img/galeri/' . $galeri['foto_galeri']);
		$this->galeriModel->delete($id);
		$this->session->setFlashdata('success', 'Data Galeri Berhasil Dihapus.');
		return redirect()->to('/admin/galeri');
	}
}
