<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open('/admin/users/create') ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="email">Email Address</label>
                  <input type="email" name="email" id="email" class="form-control <?= (validation_show_error('email') ? "is-invalid" : "") ?>" value="<?= set_value('email') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('email') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="nama">Nama Lengkap</label>
                  <input type="text" name="nama" id="nama" class="form-control <?= (validation_show_error('nama') ? "is-invalid" : "") ?>" value="<?= set_value('nama') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('nama') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="username">Username</label>
                  <input type="text" name="username" id="username" class="form-control <?= (validation_show_error('username') ? "is-invalid" : "") ?>" value="<?= set_value('username') ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('username') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="password">Password</label>
                  <input type="password" name="password" id="password" class="form-control <?= (validation_show_error('password') ? "is-invalid" : "") ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('password') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="roles">Hak Akses</label>
                  <select name="roles" id="roles" class="form-control <?= (validation_show_error('roles') ? "is-invalid" : "") ?>">
                     <option value="">-- Hak Akses --</option>
                     <option value="1" <?php if (set_value('roles') == '1') echo "selected = 'selected'" ?>>Administrator</option>
                     <option value="2" <?php if (set_value('roles') == '2') echo "selected = 'selected'" ?>>User</option>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('roles') ?>
                  </div>
               </div>
               <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>