<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-800"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open('/admin/tahunajaran/create') ?>
               <?= csrf_field(); ?>
               <div class="form-group">
                  <label for="tahun_ajaran">Tahun Ajaran</label>
                  <select name="tahun_ajaran" id="tahun_ajaran" class="form-control <?= (validation_show_error('tahun_ajaran') ? "is-invalid" : "") ?>">
                     <option value="">-- Pilih Tahun Ajaran --</option>
                     <?php for ($i = 2000; $i <= date('Y'); $i++) : ?>
                        <option value="<?= $i . "/" . ($i + 1); ?>" <?php if (set_value('tahun_ajaran') == $i . "/" . ($i + 1)) echo "selected = 'selected'" ?>><?= $i . "/" . ($i + 1); ?></option>
                     <?php endfor; ?>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('tahun_ajaran') ?>
                  </div>
               </div>
               <div class="form-group">
                  <label for="status">Status</label>
                  <select name="status" id="status" class="form-control <?= (validation_show_error('status') ? "is-invalid" : "") ?>">
                     <option value="">-- Pilih Status --</option>
                     <option value="0" <?php if (set_value('status') == '0') echo "selected = 'selected'" ?>>Tidak Aktif</option>
                     <option value="1" <?php if (set_value('status') == '1') echo "selected = 'selected'" ?>>Aktif</option>
                  </select>
                  <div class="invalid-feedback">
                     <?= validation_show_error('status') ?>
                  </div>
               </div>
               <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg">Simpan</button>
               </div>
               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>