<?= $this->extend('layouts/theme-backend') ?>
<?= $this->section('content') ?>

<div class="container-fluid mt-4">
  <div class="card shadow">
    <div class="card-header bg-primary text-white d-flex justify-content-between">
      <h4 class="mb-0">Daftar Pendaftar PPDB</h4>
      <div>
        <a href="<?= base_url('ppdb/exportExcel') ?>" class="btn btn-success btn-sm">
          <i class="fas fa-file-excel"></i> Export Excel
        </a>
        <a href="<?= base_url('ppdb/exportPdf') ?>" class="btn btn-danger btn-sm">
          <i class="fas fa-file-pdf"></i> Export PDF
        </a>
      </div>
    </div>
    <div class="card-body">
      <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success">
          <?= session()->getFlashdata('success') ?>
        </div>
      <?php endif; ?>

      <div class="table-responsive">
        <table class="table table-bordered table-striped" id="ppdbTable">
          <thead>
            <tr>
              <th>No</th>
              <th>Nama Lengkap</th>
              <th>Jenis Kelamin</th>
              <th>Tempat/Tgl Lahir</th>
              <th>Agama</th>
              <th>No HP</th>
              <th>Tanggal Daftar</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no=1; foreach ($pendaftar as $p): ?>
              <tr>
                <td><?= $no++ ?></td>
                <td><?= esc($p['nama_lengkap']) ?></td>
                <td><?= esc($p['jenis_kelamin']) ?></td>
                <td><?= esc($p['tempat_tgl_lahir']) ?></td>
                <td><?= esc($p['agama']) ?></td>
                <td><?= esc($p['no_hp']) ?></td>
                <td><?= date('d-m-Y H:i', strtotime($p['created_at'])) ?></td>
                <td>
                  <a href="<?= base_url('ppdb/edit/'.$p['id']) ?>" class="btn btn-warning btn-sm">
                    <i class="fas fa-edit"></i>
                  </a>
                  <a href="<?= base_url('ppdb/delete/'.$p['id']) ?>" class="btn btn-danger btn-sm"
                     onclick="return confirm('Yakin ingin menghapus data ini?')">
                    <i class="fas fa-trash"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('script') ?>
<script>
  $(document).ready(function () {
    $('#ppdbTable').DataTable();
  });
</script>
<?= $this->endSection() ?>
