<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900">Edit Ekstrakurikuler <?= esc($ekstrakurikuler['ekstrakurikuler']); ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <div class="row">
            <div class="col-md-6">
               <?= form_open_multipart('/admin/ekstrakurikuler/update/' . $ekstrakurikuler['id']) ?>
               <?= csrf_field(); ?>

               <input type="hidden" name="foto_ekstrakurikuler_lama" 
                      value="<?= esc($ekstrakurikuler['foto_ekstrakurikuler']); ?>">

               <div class="form-group">
                  <label for="ekstrakurikuler">Ekstrakurikuler</label>
                  <input type="text" 
                         name="ekstrakurikuler" 
                         id="ekstrakurikuler" 
                         class="form-control <?= (validation_show_error('ekstrakurikuler') ? "is-invalid" : "") ?>" 
                         value="<?= old('ekstrakurikuler', $ekstrakurikuler['ekstrakurikuler']); ?>">
                  <div class="invalid-feedback">
                     <?= validation_show_error('ekstrakurikuler') ?>
                  </div>
               </div>

               <div class="form-group">
                  <label for="deskripsi">Deskripsi</label>
                  <textarea name="deskripsi" 
                            id="deskripsi" 
                            class="form-control <?= (validation_show_error('deskripsi') ? "is-invalid" : "") ?>"><?= old('deskripsi', $ekstrakurikuler['isi']); ?></textarea>
                  <div class="invalid-feedback">
                     <?= validation_show_error('deskripsi') ?>
                  </div>
               </div>

               <div class="form-group">
                  <label for="foto_ekstrakurikuler">Foto <small>(Format .jpg, .jpeg, .png)</small></label><br>

                  <?php if (!empty($ekstrakurikuler['foto_ekstrakurikuler']) && file_exists(FCPATH . 'img/ekstrakurikuler/' . $ekstrakurikuler['foto_ekstrakurikuler'])): ?>
                     <img src="<?= base_url('img/ekstrakurikuler/' . $ekstrakurikuler['foto_ekstrakurikuler']) ?>" 
                          alt="Foto Ekstrakurikuler" class="img-fluid mb-3" width="300">
                  <?php else: ?>
                     <p class="text-muted"><i>Tidak ada foto lama</i></p>
                  <?php endif; ?>

                  <input type="file" 
                         name="foto_ekstrakurikuler" 
                         id="foto_ekstrakurikuler" 
                         class="form-control-file <?= (validation_show_error('foto_ekstrakurikuler') ? "is-invalid" : "") ?>" 
                         onchange="readFoto(event)">
                  <div class="invalid-feedback">
                     <?= validation_show_error('foto_ekstrakurikuler') ?>
                  </div>
                  <img id="output" class="mt-3 mb-0" style="width: 300px; display:none;">
               </div>

               <div class="form-group mt-4">
                  <button type="submit" class="btn btn-primary btn-lg">Update</button>
               </div>

               <?= form_close(); ?>
            </div>
         </div>
      </div>
   </div>
</div>

<script>
   function readFoto(event) {
      const output = document.getElementById('output');
      output.src = URL.createObjectURL(event.target.files[0]);
      output.style.display = "block";
   }
</script>

<?= $this->endSection() ?>
