<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddUploadFieldsToPpdb extends Migration
{
    public function up()
    {
        // Cek apakah kolom bukti_tf sudah ada
        $db = \Config\Database::connect();
        $builder = $db->query("SHOW COLUMNS FROM ppdb LIKE 'bukti_tf'");
        
        if ($builder->getNumRows() == 0) {
            // Menambah field upload untuk Bukti TF, Akta Kelahiran, dan KK
            $this->forge->addColumn('ppdb', [
                'bukti_tf' => [
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true,
                    'comment' => 'File bukti transfer pembayaran'
                ],
                'akta_kelahiran' => [
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true,
                    'comment' => 'File akta kelahiran'
                ],
                'kartu_keluarga' => [
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true,
                    'comment' => 'File kartu keluarga'
                ]
            ]);
        }

        // Cek apakah kolom tgl_daftar masih ada, jika ya hapus
        $builder2 = $db->query("SHOW COLUMNS FROM ppdb LIKE 'tgl_daftar'");
        if ($builder2->getNumRows() > 0) {
            $this->forge->dropColumn('ppdb', 'tgl_daftar');
        }
    }

    public function down()
    {
        // Rollback: hapus field upload
        $this->forge->dropColumn('ppdb', ['bukti_tf', 'akta_kelahiran', 'kartu_keluarga']);
        
        // Rollback: tambah kembali field tgl_daftar
        $this->forge->addColumn('ppdb', [
            'tgl_daftar' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true
            ]
        ]);
    }
}
