<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddPekerjaanIbuToPpdbTable extends Migration
{
    public function up()
    {
        // Cek apakah kolom pekerjaan_ibu sudah ada
        $db = \Config\Database::connect();
        $builder = $db->query("SHOW COLUMNS FROM ppdb LIKE 'pekerjaan_ibu'");
        
        if ($builder->getNumRows() == 0) {
            // Menambahkan kolom pekerjaan_ibu yang missing di tabel ppdb
            $this->forge->addColumn('ppdb', [
                'pekerjaan_ibu' => [
                    'type'       => 'VARCHAR',
                    'constraint' => 100,
                    'null'       => true,
                    'after'      => 'pekerjaan_ayah'
                ]
            ]);
        }
    }

    public function down()
    {
        // Menghapus kolom pekerjaan_ibu jika rollback
        $this->forge->dropColumn('ppdb', 'pekerjaan_ibu');
    }
}
