<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use \App\Models\TahunajaranModel;

class Tahunajaran extends BaseController
{
	protected $tahunModel;

	public function __construct()
	{
		$this->tahunModel = new TahunajaranModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}
		
		return view('admin/tahun-ajaran/index', [
			'title' => 'Tahun Ajaran',
			'tahun' => $this->tahunModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/tahun-ajaran/create', [
			'title' => 'Tambah Data Tahun Ajaran',
			'validation' => $this->validation,
		]);
	}

	public function create()
	{
		$rules = [
			'tahun_ajaran' => [
				'rules'  => 'required',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		$data = [
			'tahun_ajaran' => $this->request->getPost('tahun_ajaran'),
			'status' => $this->request->getPost('status'),
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		} else {
			$this->tahunModel->insert($data);
			$this->session->setFlashdata('success', 'Data Tahun Berhasil Ditambahkan.');
			return redirect()->to('/admin/tahunajaran');
		}
	}

	public function edit($id)
	{
		return view('admin/tahun-ajaran/edit', [
			'title' => 'Edit Data Tahun Ajaran',
			'tahun' => $this->tahunModel->find($id),
			'validation' => $this->validation,
		]);
	}

	public function update($id)
	{
		$rules = [
			'tahun_ajaran' => [
				'rules'  => 'required',
				'errors' => []
			],
			'status' => [
				'rules'  => 'required',
				'errors' => []
			],
		];

		$data = [
			'tahun_ajaran' => $this->request->getPost('tahun_ajaran'),
			'status' => $this->request->getPost('status'),
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		} else {
			$this->tahunModel->update($id, $data);
			$this->session->setFlashdata('success', 'Data Tahun Berhasil Diubah.');
			return redirect()->to('/admin/tahunajaran');
		}
	}

	public function delete($id)
	{
		$this->tahunModel->delete($id);
		$this->session->setFlashdata('success', 'Data Tahun Berhasil Dihapus.');
		return redirect()->to('/admin/tahunajaran');
	}

	public function active($id)
	{
		$this->tahunModel->resetStatus();
		$data = [
			'status' => 1
		];

		$this->tahunModel->activeStatus($data, $id);
		session()->setFlashdata('success', 'Tahun Akademik Berhasil Diaktifkan.');
		return redirect()->to('/admin/tahunajaran');
	}
}
