<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EkstrakurikulerModel;

class Ekstrakurikuler extends BaseController
{
	protected $ekstraModel;
	
	public function __construct()
	{
		$this->ekstraModel = new EkstrakurikulerModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}
		
		return view('admin/ekstrakurikuler/index', [
			'title' => 'Ekstrakurikuler',
			'ekstrakurikuler' => $this->ekstraModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/ekstrakurikuler/create', [
			'title' => 'Tambah Data Ekstrakurikuler',
			'validation' => $this->validation
		]);
	}

	public function create()
	{
		$rules = [
			'ekstrakurikuler' => [
				'rules'  => 'required',
				'errors' => []
			],
			'deskripsi' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_ekstrakurikuler' => [
				'rules'  => 'uploaded[foto_ekstrakurikuler]|mime_in[foto_ekstrakurikuler,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_ekstrakurikuler,jpg,jpeg,png]',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_ekstrakurikuler');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/ekstrakurikuler', $newName);
		}
		$data = [
			'ekstrakurikuler' => $this->request->getPost('ekstrakurikuler'),
			'isi' => $this->request->getPost('deskripsi'),
			'foto_ekstrakurikuler' => $newName,
		];

		$this->ekstraModel->insert($data);
		$this->session->setFlashdata('success', 'Data Ekstrakurikuler Berhasil Ditambahkan.');
		return redirect()->to('/admin/ekstrakurikuler');
	}

	public function edit($id)
	{
		return view('admin/ekstrakurikuler/edit', [
			'title' => 'Edit Data Ekstrakurikuler',
			'ekstrakurikuler' => $this->ekstraModel->find($id),
			'validation' => $this->validation
		]);
	}

	public function update($id)
	{
		try {
			$foto = $this->request->getFile('foto_ekstrakurikuler');
			if ($foto->isValid() && !$foto->hasMoved()) {
				$newName = $foto->getRandomName();
				$foto->move('img/ekstrakurikuler', $newName);

				$fotoLama = $this->request->getPost('foto_ekstrakurikuler_lama');
				if ($fotoLama && $fotoLama != 'default.jpg' && file_exists('img/ekstrakurikuler/' . $fotoLama)) {
					unlink('img/ekstrakurikuler/' . $fotoLama);
				}
			} else {
				$newName = $this->request->getPost('foto_ekstrakurikuler_lama');
			}

			$data = [
				'ekstrakurikuler' => $this->request->getPost('ekstrakurikuler'),
				'isi'   => $this->request->getPost('deskripsi'),
				'foto_ekstrakurikuler' => $newName,
			];

			$this->ekstraModel->update($id, $data);
			session()->setFlashdata('success', 'Data ekstrakurikuler berhasil diubah.');
			return redirect()->to('/admin/ekstrakurikuler');
			
		} catch (\Exception $e) {
			log_message('error', 'Ekstrakurikuler Update Error: ' . $e->getMessage());
			session()->setFlashdata('error', 'Terjadi kesalahan saat mengupdate data ekstrakurikuler: ' . $e->getMessage());
			return redirect()->back()->withInput();
		}
	}

	public function delete($id)
	{
		$ekstrakurikuler = $this->ekstraModel->find($id);

		if ($ekstrakurikuler && $ekstrakurikuler['foto_ekstrakurikuler'] != 'default.jpg' && file_exists('img/ekstrakurikuler/' . $ekstrakurikuler['foto_ekstrakurikuler'])) {
			unlink('img/ekstrakurikuler/' . $ekstrakurikuler['foto_ekstrakurikuler']);
		}

		$this->ekstraModel->delete($id);
		session()->setFlashdata('success', 'Data ekstrakurikuler berhasil dihapus.');
		return redirect()->to('/admin/ekstrakurikuler');
	}

	}
