<?php

use \App\Models\PengaturanwebModel;

$pengaturan = new PengaturanwebModel;
$infoSekolah = $pengaturan->first();
$namaSekolah = $infoSekolah['nama_website'];
$logoSekolah = $infoSekolah['logo_sekolah'];
$visiSekolah = $infoSekolah['visi'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Lupa Password - Verifikasi</title>
    <meta name="description" content="">
    <meta name="author" content="">

    <link rel="shortcut icon" href="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" type="image/x-icon">

    <!-- Custom fonts for this template-->
    <link href="<?= base_url('assets/vendor/fontawesome-free/css/all.min.css') ?>" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?= base_url('template/assets/login/css/style.css') ?>" rel="stylesheet">
</head>

<body style="background-color: #66c2ff;">
    <section class="ftco-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-10">
                    <div class="wrap d-md-flex">

                        <div class="text-wrap p-4 p-lg-5 text-center d-flex align-items-center order-md-last">
                            <div class="text w-100">
                                <p>
                                    <img src="<?= base_url('img/pengaturan/' . $logoSekolah) ?>" alt="" class="img img-thumbnail rounded-circle" style="max-height: 100px; width: auto;">
                                </p>
                                <h2><?= $namaSekolah; ?></h2>
                                <p><?= $visiSekolah; ?></p>
                            </div>
                        </div>

                        <div class="login-wrap p-4 p-lg-5">
                            <h1 class="h3 mb-3">Lupa Password</h1>
                            <p class="text-muted mb-4">Masukkan username dan email Anda untuk verifikasi identitas</p>
                            <hr />
                            
                            <?php if (session()->getFlashdata('danger') != null) : ?>
                                <div class="alert alert-danger">
                                    <span><?= session()->getFlashdata('danger'); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (session()->getFlashdata('success') != null) : ?>
                                <div class="alert alert-success">
                                    <span><?= session()->getFlashdata('success'); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?= form_open('auth/verify-account'); ?>
                            <?= csrf_field(); ?>
                            
                            <div class="form-group mb-3">
                                <label class="label" for="username">Username</label>
                                <input type="text" name="username" class="form-control form-control-lg <?= (validation_show_error('username') ? "is-invalid" : "") ?>" id="username" placeholder="Masukkan Username..." value="<?= set_value('username') ?>">
                                <div class="invalid-feedback">
                                    <?= validation_show_error('username') ?>
                                </div>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label class="label" for="email">Email</label>
                                <input type="email" name="email" class="form-control form-control-lg <?= (validation_show_error('email') ? "is-invalid" : "") ?>" id="email" placeholder="Masukkan Email..." value="<?= set_value('email') ?>">
                                <div class="invalid-feedback">
                                    <?= validation_show_error('email') ?>
                                </div>
                            </div>
                            
                            <button type="submit" class="form-control btn btn-primary submit px-3">
                                <i class="fas fa-search"></i> Verifikasi
                            </button>
                            <?= form_close(); ?>
                            
                            <div class="text-center mt-3">
                                <a href="<?= base_url('login'); ?>" class="btn btn-link text-secondary">
                                    <i class="fas fa-arrow-left"></i> Kembali ke Login
                                </a>
                            </div>
                            
                            <hr />
                            <a href="<?= base_url(); ?>" alt="Home"><i class="fas fa-home"></i> Kembali ke Home</a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Bootstrap core JavaScript-->
    <script src="<?= base_url() ?>template/assets/login/js/jquery.min.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/popper.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/bootstrap.min.js"></script>
	<script src="<?= base_url() ?>template/assets/login/js/main.js"></script>

</body>

</html>