<?= $this->extend('layouts/theme-backend') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Edit Data Pendaftar PPDB</h6>
    </div>
    <div class="card-body">
      <form method="post" action="<?= base_url('admin/ppdb/update/'.$siswa['id']) ?>">
        <?= csrf_field() ?>
        
        <!-- Data Siswa -->
        <div class="card mb-4">
          <div class="card-header bg-primary text-white">
            <h6 class="mb-0">Data Siswa</h6>
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                  <input type="text" name="nama_lengkap" class="form-control" value="<?= $siswa['nama_lengkap'] ?>" required>
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Nama Panggilan <span class="text-danger">*</span></label>
                  <input type="text" name="nama_panggilan" class="form-control" value="<?= $siswa['nama_panggilan'] ?>" required>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">Jenis Kelamin <span class="text-danger">*</span></label>
                  <select name="jenis_kelamin" class="form-control" required>
                    <option value="">Pilih Jenis Kelamin</option>
                    <option value="Laki-laki" <?= $siswa['jenis_kelamin'] == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= $siswa['jenis_kelamin'] == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">Tempat, Tanggal Lahir <span class="text-danger">*</span></label>
                  <input type="text" name="tempat_tgl_lahir" class="form-control" value="<?= $siswa['tempat_tgl_lahir'] ?>" placeholder="Contoh: Cilacap, 01 Januari 2020" required>
                </div>
              </div>
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">Agama <span class="text-danger">*</span></label>
                  <select name="agama" class="form-control" required>
                    <option value="">Pilih Agama</option>
                    <option value="Islam" <?= $siswa['agama'] == 'Islam' ? 'selected' : '' ?>>Islam</option>
                    <option value="Kristen" <?= $siswa['agama'] == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                    <option value="Katolik" <?= $siswa['agama'] == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                    <option value="Hindu" <?= $siswa['agama'] == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                    <option value="Buddha" <?= $siswa['agama'] == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                    <option value="Konghucu" <?= $siswa['agama'] == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                  </select>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-3">
                <div class="mb-3">
                  <label class="form-label">Anak Nomor Ke <span class="text-danger">*</span></label>
                  <input type="number" name="anak_nomor_ke" class="form-control" value="<?= $siswa['anak_nomor_ke'] ?>" min="1" required>
                </div>
              </div>
              <div class="col-md-3">
                <div class="mb-3">
                  <label class="form-label">Banyak Saudara <span class="text-danger">*</span></label>
                  <input type="number" name="banyak_saudara" class="form-control" value="<?= $siswa['banyak_saudara'] ?>" min="1" required>
                </div>
              </div>
              <div class="col-md-3">
                <div class="mb-3">
                  <label class="form-label">Berat Badan (kg)</label>
                  <input type="number" name="berat_badan" class="form-control" value="<?= $siswa['berat_badan'] ?>" step="0.1">
                </div>
              </div>
              <div class="col-md-3">
                <div class="mb-3">
                  <label class="form-label">Tinggi Badan (cm)</label>
                  <input type="number" name="tinggi_badan" class="form-control" value="<?= $siswa['tinggi_badan'] ?>" step="0.1">
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">Umur Saat Daftar (tahun)</label>
                  <input type="number" name="umur_saat_daftar" class="form-control" value="<?= $siswa['umur_saat_daftar'] ?>" min="1">
                </div>
              </div>
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">Bahasa Sehari-hari</label>
                  <input type="text" name="bahasa_sehari" class="form-control" value="<?= $siswa['bahasa_sehari'] ?>" placeholder="Contoh: Bahasa Indonesia">
                </div>
              </div>
              <div class="col-md-4">
                <div class="mb-3">
                  <label class="form-label">No HP <span class="text-danger">*</span></label>
                  <input type="text" name="no_hp" class="form-control" value="<?= $siswa['no_hp'] ?>" required>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Data Orang Tua -->
        <div class="card mb-4">
          <div class="card-header bg-success text-white">
            <h6 class="mb-0">Data Orang Tua</h6>
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Nama Ayah <span class="text-danger">*</span></label>
                  <input type="text" name="nama_ayah" class="form-control" value="<?= $siswa['nama_ayah'] ?>" required>
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Nama Ibu <span class="text-danger">*</span></label>
                  <input type="text" name="nama_ibu" class="form-control" value="<?= $siswa['nama_ibu'] ?>" required>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pendidikan Ayah</label>
                  <select name="pendidikan_ayah" class="form-control">
                    <option value="">Pilih Pendidikan</option>
                    <option value="SD" <?= $siswa['pendidikan_ayah'] == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $siswa['pendidikan_ayah'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $siswa['pendidikan_ayah'] == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="D3" <?= $siswa['pendidikan_ayah'] == 'D3' ? 'selected' : '' ?>>D3</option>
                    <option value="S1" <?= $siswa['pendidikan_ayah'] == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $siswa['pendidikan_ayah'] == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $siswa['pendidikan_ayah'] == 'S3' ? 'selected' : '' ?>>S3</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pendidikan Ibu</label>
                  <select name="pendidikan_ibu" class="form-control">
                    <option value="">Pilih Pendidikan</option>
                    <option value="SD" <?= $siswa['pendidikan_ibu'] == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $siswa['pendidikan_ibu'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $siswa['pendidikan_ibu'] == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="D3" <?= $siswa['pendidikan_ibu'] == 'D3' ? 'selected' : '' ?>>D3</option>
                    <option value="S1" <?= $siswa['pendidikan_ibu'] == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $siswa['pendidikan_ibu'] == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $siswa['pendidikan_ibu'] == 'S3' ? 'selected' : '' ?>>S3</option>
                  </select>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pekerjaan Ayah</label>
                  <input type="text" name="pekerjaan_ayah" class="form-control" value="<?= $siswa['pekerjaan_ayah'] ?>" placeholder="Contoh: PNS, Guru, Wiraswasta, dll">
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pekerjaan Ibu</label>
                  <input type="text" name="pekerjaan_ibu" class="form-control" value="<?= $siswa['pekerjaan_ibu'] ?? '' ?>" placeholder="Contoh: PNS, Guru, Ibu Rumah Tangga, dll">
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Data Wali -->
        <div class="card mb-4">
          <div class="card-header bg-warning text-white">
            <h6 class="mb-0">Data Wali</h6>
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Nama Wali</label>
                  <input type="text" name="nama_wali" class="form-control" value="<?= $siswa['nama_wali'] ?>">
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Hubungan dengan Wali</label>
                  <select name="hubungan_wali" class="form-control">
                    <option value="">Pilih Hubungan</option>
                    <option value="Ayah" <?= $siswa['hubungan_wali'] == 'Ayah' ? 'selected' : '' ?>>Ayah</option>
                    <option value="Ibu" <?= $siswa['hubungan_wali'] == 'Ibu' ? 'selected' : '' ?>>Ibu</option>
                    <option value="Kakek" <?= $siswa['hubungan_wali'] == 'Kakek' ? 'selected' : '' ?>>Kakek</option>
                    <option value="Nenek" <?= $siswa['hubungan_wali'] == 'Nenek' ? 'selected' : '' ?>>Nenek</option>
                    <option value="Paman" <?= $siswa['hubungan_wali'] == 'Paman' ? 'selected' : '' ?>>Paman</option>
                    <option value="Bibi" <?= $siswa['hubungan_wali'] == 'Bibi' ? 'selected' : '' ?>>Bibi</option>
                    <option value="Kakak" <?= $siswa['hubungan_wali'] == 'Kakak' ? 'selected' : '' ?>>Kakak</option>
                    <option value="Lainnya" <?= $siswa['hubungan_wali'] == 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
                  </select>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pendidikan Wali</label>
                  <select name="pendidikan_wali" class="form-control">
                    <option value="">Pilih Pendidikan</option>
                    <option value="SD" <?= $siswa['pendidikan_wali'] == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $siswa['pendidikan_wali'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $siswa['pendidikan_wali'] == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="D3" <?= $siswa['pendidikan_wali'] == 'D3' ? 'selected' : '' ?>>D3</option>
                    <option value="S1" <?= $siswa['pendidikan_wali'] == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $siswa['pendidikan_wali'] == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $siswa['pendidikan_wali'] == 'S3' ? 'selected' : '' ?>>S3</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Pekerjaan Wali</label>
                  <input type="text" name="pekerjaan_wali" class="form-control" value="<?= $siswa['pekerjaan_wali'] ?>">
                </div>
              </div>
            </div>
            
            <div class="mb-3">
              <label class="form-label">Alamat Wali</label>
              <textarea name="alamat_wali" class="form-control" rows="3" placeholder="Masukkan alamat lengkap wali"><?= $siswa['alamat_wali'] ?></textarea>
            </div>
          </div>
        </div>

        <!-- Data Tambahan -->
        <div class="card mb-4">
          <div class="card-header bg-info text-white">
            <h6 class="mb-0">Data Tambahan</h6>
          </div>
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Asal Mula</label>
                  <select name="asal_mula" class="form-control">
                    <option value="">Pilih Asal Mula</option>
                    <option value="Siswa Baru" <?= $siswa['asal_mula'] == 'Siswa Baru' ? 'selected' : '' ?>>Siswa Baru</option>
                    <option value="Siswa Pindahan" <?= $siswa['asal_mula'] == 'Siswa Pindahan' ? 'selected' : '' ?>>Siswa Pindahan</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Status</label>
                  <select name="status" class="form-control">
                    <option value="Pending" <?= $siswa['status'] == 'Pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="Diterima" <?= $siswa['status'] == 'Diterima' ? 'selected' : '' ?>>Diterima</option>
                    <option value="Ditolak" <?= $siswa['status'] == 'Ditolak' ? 'selected' : '' ?>>Ditolak</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="d-flex justify-content-between">
          <a href="<?= base_url('admin/ppdb') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
          </a>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Simpan Perubahan
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<?= $this->endSection() ?>
