<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
         <?= form_open_multipart('/admin/pengaturanweb/update/' . $pengaturan['id']) ?>
         <?= csrf_field(); ?>
         <div class="row">
            <div class="col-md-6">
               <div class="form-group">
                  <label for="nama_website">Nama Web Sekolah</label>
                  <input type="text" name="nama_website" id="nama_website" class="form-control" required value="<?= ($pengaturan['nama_website'] ? $pengaturan['nama_website'] : 'Wajib Diisi.') ?>">
               </div>
               <div class="form-group">
                  <label for="visi">Visi</label>
                  <textarea name="visi" id="isi" class="form-control"><?= ($pengaturan['visi'] ? $pengaturan['visi'] : 'Wajib Diisi.') ?></textarea>
               </div>
               <div class="form-group">
                  <label for="misi">Misi</label>
                  <textarea name="misi" id="misi" class="form-control"><?= ($pengaturan['misi'] ? $pengaturan['misi'] : 'Wajib Diisi.') ?></textarea>
               </div>
               <div class="form-group">
                  <label for="alamat">Alamat</label>
                  <textarea name="alamat" id="alamat" class="form-control"><?= ($pengaturan['alamat'] ? $pengaturan['alamat'] : 'Wajib Diisi.') ?></textarea>
               </div>
               <div class="form-group">
                  <label for="email">Email</label>
                  <input type="email" name="email" id="email" class="form-control" required value="<?= ($pengaturan['email'] ? $pengaturan['email'] : 'Wajib Diisi.') ?>">
               </div>
               <div class="form-group">
                  <label for="no_telp">Telepon</label>
                  <input type="number" name="no_telp" id="no_telp" class="form-control" required value="<?= ($pengaturan['no_telp'] ? $pengaturan['no_telp'] : 'Wajib Diisi.') ?>">
               </div>
               <div class="form-group">
                  <label for="no_whatsapp">No.Whatsapp (Format 62)</label>
                  <input type="number" name="no_whatsapp" id="no_whatsapp" class="form-control" required value="<?= ($pengaturan['no_whatsapp'] ? $pengaturan['no_whatsapp'] : 'Wajib Diisi.') ?>">
               </div>
            </div>
            <div class="col-md-6">
               <div class="form-group">
                  <label for="text_navbar">Mode Warna Navbar (mempengaruhi warna text)</label>
                  <select name="text_navbar" class="form-control">
                     <option value="dark" <?= ($pengaturan['txcolor_navbar'] == 'dark' ? 'selected="selected"' : '') ?>>Gelap (Dark) / Warna Text Putih</option>
                     <option value="light" <?= ($pengaturan['txcolor_navbar'] == 'light' ? 'selected="selected"' : '') ?>>Terang (Light) / Warna Text Hitam</option>
                  </select>
               </div>
               <div class="form-group">
                  <label for="color_navbar">Warna Navbar</label>
                  <input type="color" class="form-control" name="color_navbar" value="<?= ($pengaturan['bgcolor_navbar'] ? $pengaturan['bgcolor_navbar'] : '#0DCAF0') ?>">
               </div>
               <div class="form-group">
                  <label for="color_footer">Warna Footer</label>
                  <input type="color" class="form-control" name="color_footer" value="<?= ($pengaturan['bgcolor_footer'] ? $pengaturan['bgcolor_footer'] : '#0D6EFD') ?>">
               </div>
               <div class="row">
                  <div class="col-md-6">
                     <div class="form-group">
                        <label for="logo_sekolah">Logo Sekolah</label>
                        <input type="file" name="logo_sekolah" id="logo_sekolah" class="form-control-file"><br>
                        <input type="hidden" name="logo_sekolah_lama" id="logo_sekolah_lama" class="form-control-file" required value="<?= $pengaturan['logo_sekolah']; ?>">
                        <img src="<?= base_url('img/pengaturan/' . ($pengaturan['logo_sekolah'] ? $pengaturan['logo_sekolah'] : 'default.png')) ?>" width="150" class="img-fluid">
                     </div>
                     <!-- <div class="form-group">
                        <label for="logo_akreditasi">Logo Akreditasi</label>
                        <input type="file" name="logo_akreditasi" id="logo_akreditasi" class="form-control-file"><br>
                        <input type="hidden" name="logo_akreditasi_lama" id="logo_akreditasi_lama" class="form-control-file" required value="<?= $pengaturan['logo_akreditasi']; ?>">
                        <img src="<?= base_url('img/pengaturan/' . ($pengaturan['logo_akreditasi'] ? $pengaturan['logo_akreditasi'] : 'default.png')) ?>" width="150" class="img-fluid">
                     </div> -->
                  </div>
                  <div class="col-md-6">
                     <!-- <div class="form-group">
                        <label for="logo_wilayah">Logo Wilayah</label>
                        <input type="file" name="logo_wilayah" id="logo_wilayah" class="form-control-file"><br>
                        <input type="hidden" name="logo_wilayah_lama" id="logo_wilayah_lama" class="form-control-file" required value="<?= $pengaturan['logo_wilayah']; ?>">
                        <img src="<?= base_url('img/pengaturan/' . ($pengaturan['logo_wilayah'] ? $pengaturan['logo_wilayah'] : 'default.png')) ?>" width="150" class="img-fluid">
                     </div> -->
                     <!-- <div class="form-group">
                        <label for="logo_kabupaten">Logo Kabupaten</label>
                        <input type="file" name="logo_kabupaten" id="logo_kabupaten" class="form-control-file"><br>
                        <input type="hidden" name="logo_kabupaten_lama" id="logo_kabupaten_lama" class="form-control-file" required value="<?= $pengaturan['logo_kabupaten']; ?>">
                        <img src="<?= base_url('img/pengaturan/' . ($pengaturan['logo_kabupaten'] ? $pengaturan['logo_kabupaten'] : 'default.png')) ?>" width="150" class="img-fluid">
                     </div> -->
                  </div>
               </div>
               <div class="form-group">
                  <label for="struktur_organisasi">Struktur Organisasi</label>
                  <input type="file" name="struktur_organisasi" id="struktur_organisasi" class="form-control-file"><br>
                  <input type="hidden" name="struktur_organisasi_lama" id="struktur_organisasi_lama" class="form-control-file" required value="<?= $pengaturan['struktur_organisasi']; ?>">
                  <img src="<?= base_url('img/pengaturan/' . ($pengaturan['struktur_organisasi'] ? $pengaturan['struktur_organisasi'] : 'default.png')) ?>" width="450" class="img-fluid">
               </div>               
            </div>
            <div class="col-6">
               <div class="form-group">
                  <label for="gmaps">Google Maps IFrame</label>
                  <textarea name="gmaps" id="gmaps" class="form-control" rows="8"><?= ($pengaturan['gmaps'] ? $pengaturan['gmaps'] : 'Wajib Diisi.') ?></textarea>
               </div>
            </div>
            <div class="col-6">
               <!-- <div class="form-group">
                  <label for="facebook">Facebook</label>
                  <input type="text" name="facebook" id="facebook" class="form-control" required value="<?= ($pengaturan['facebook'] ? $pengaturan['facebook'] : 'Wajib Diisi.') ?>" placeholder="Link Facebook">
               </div> -->
               <!-- <div class="form-group">
                  <label for="twitter">Twitter</label>
                  <input type="text" name="twitter" id="twitter" class="form-control" required value="<?= ($pengaturan['twitter'] ? $pengaturan['twitter'] : 'Wajib Diisi.') ?>" placeholder="Link Twitter">
               </div> -->
               <!-- <div class="form-group">
                  <label for="instagram">Instagram</label>
                  <input type="text" name="instagram" id="instagram" class="form-control" required value="<?= ($pengaturan['instagram'] ? $pengaturan['instagram'] : 'Wajib Diisi.') ?>" placeholder="Link Instagram">
               </div> -->
            </div>
         </div>
         <div class="form-group">
            <button type="submit" class="btn btn-primary btn-lg mt-4">Simpan</button>
         </div>
         <?= form_close(); ?>
      </div>
   </div>
</div>
<?= $this->endSection() ?>