<?= $this->extend('layouts/theme-backend') ?>

<?= $this->section('content') ?>
<h1 class="h2 mb-3 text-gray-900"><?= $title; ?></h1>

<div id="content">
   <div class="card shadow mb-4">
      <div class="card-body">
      <a href="<?= base_url('admin/ekstrakurikuler/new'); ?>" class="btn btn-primary mb-4">Tambah Ekstrakurikuler</a>
         <div class="table-responsive">
            <table class="m-0 font-weight-bold table">
               <thead>
                  <tr>
                     <th>No</th>
                     <th>Foto</th>
                     <th>Ekstrakurikuler</th>
                     <th>Deskripsi</th>
                     <th>Aksi</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $no = 1;
                  foreach ($ekstrakurikuler as $e) : ?>
                     <tr>
                        <td><?= $no++; ?></td>
                        <td>
                           <img src="<?= base_url('img/ekstrakurikuler/' . $e['foto_ekstrakurikuler']) ?>" width="100" class="img-fluid">
                        </td>
                        <td><?= $e['ekstrakurikuler']; ?></td>
                        <td><?= $e['isi']; ?></td>
                        <td>
                           <a href="<?= base_url('admin/ekstrakurikuler/edit/' . $e['id']) ?>" class="btn btn-primary">Edit</a>
                           <form action="<?= base_url('admin/ekstrakurikuler/delete/'. $e['id']); ?>" method="POST" class="d-inline-block">
                              <?= csrf_field(); ?>
                              <input type="hidden" name="_method" value="DELETE">
                              <button type="submit" class="btn btn-danger text-light" onclick="return confirm('Apakah anda yakin menghapus data ini?')">Hapus</button>
                           </form>
                        </td>
                     </tr>
                  <?php endforeach; ?>
               </tbody>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>