<?php

namespace App\Models;

/*
IT Shop Purwokerto (Tokopedia, Shopee & Bukalapak)
Dibuat oleh: Hari Wicaksono, S.Kom
06-2022
*/

use CodeIgniter\Model;

class DashboardModel extends Model
{
    
    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    // hitung total data pada guru
    public function getCountGuru()
    {
        return $this->db->table("guru")->countAll();
    }

    // hitung total data pada siswa
    public function getCountSiswa()
    {
        return $this->db->table("siswa")->countAll();
    }

    // hitung total data pada artikel
    public function getCountArtikel()
    {
        return $this->db->table("artikel")->countAll();
    }

    // hitung total data pada kontak
    public function getCountKontak()
    {
        return $this->db->table("kontak")->countAll();
    }

    // hitung total data pada user
    public function getCountUser()
    {
        return $this->db->table("logins")->countAll();
    }

    public function chartTransaksi($date)
    {
        $this->like('created_at', $date, 'after');
        return count($this->get()->getResultArray());
    }

    public function chartHarian($date)
    {
        $this->like('created_at', $date, 'after');
        return count($this->get()->getResultArray());
    }

    public function chartPemasukan($date)
    {
        $this->select('sum(total) as total');
        $this->like('created_at', $date, 'after');
        return $this->get()->getRow()->total;
    }

    public function countTrxHariini()
    {
        $this->where('DATE(created_at) =', date('Y-m-d'));
        return count($this->get()->getResultArray());
    }

    public function countTrxHarikemarin()
    {
        $this->where('DATE(created_at) =', date('Y-m-d', strtotime('-1 days')));
        return count($this->get()->getResultArray());
    }

    public function totalTrxHariini()
    {
        $this->select('sum(total) as total');
        $this->where('DATE(created_at) =', date('Y-m-d'));
        return $this->get()->getRow()->total;
    }

    public function totalTrxHarikemarin()
    {
        $this->select('sum(total) as total');
        $this->where('DATE(created_at) =', date('Y-m-d', strtotime('-1 days')));
        return $this->get()->getRow()->total;
    }

    public function kasMasukHariini()
    {
        $query = $this->db->table('kas_saldos')
            ->select('sum(nominal) as total')
            ->like('jenis', 'Pemasukan')
            ->where('DATE(created_at) =', date('Y-m-d'));
        return $query->get()->getRow()->total;
    }

    public function kasKeluarHariini()
    {
        $query = $this->db->table('kas_saldos')
            ->select('sum(nominal) as total')
            ->groupStart()
            ->like('jenis', 'Pengeluaran')
            ->orLike('jenis', 'Mutasi ke Bank', 'before')
            ->groupEnd()
            ->where('DATE(created_at) =', date('Y-m-d'));
        return $query->get()->getRow()->total;
    }
}
