<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\DashboardModel;
use App\Models\PengaturanwebModel;

class Dashboard extends BaseController
{
    protected $dashboardModel;
    protected $settingModel;

    public function __construct()
    {
        $this->dashboardModel = new DashboardModel();
        $this->settingModel   = new PengaturanwebModel();
    }

    public function index()
    {
        return view('admin/dashboard', [
            'title'    => 'Dashboard',
            'setting'  => $this->settingModel->first(),
            'jmlGuru'  => $this->dashboardModel->getCountGuru(),
            'jmlSiswa' => $this->dashboardModel->getCountSiswa(),
            'jmlArtikel' => $this->dashboardModel->getCountArtikel(),
            'jmlKontak'  => $this->dashboardModel->getCountKontak(),
        ]);
    }
}
