<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('ppdb/pendaftaran', 'Ppdb::pendaftaran');
$routes->post('ppdb/save', 'Ppdb::save');
$routes->post('home/loadmore', 'Home::load_more');
$routes->get('ppdb_form', function () {
    return view('ppdb_form');
});


$routes->get('login', 'Auth::index');
$routes->post('auth/login', 'Auth::login');
$routes->get('auth/logout', 'Auth::logout');

// Routes untuk Lupa Password
$routes->get('auth/forgot-password', 'Auth::forgotPassword');
$routes->post('auth/verify-account', 'Auth::verifyAccount');
$routes->get('auth/reset-password', 'Auth::resetPassword');
$routes->post('auth/update-password', 'Auth::updatePassword');

$routes->get('sambutan-kepala-sekolah', 'Home::sambutan_kepsek');
$routes->get('struktur-organisasi', 'Home::struktur_organisasi');
$routes->get('visi-misi', 'Home::visi_misi');
$routes->get('guru-staf', 'Home::guru');
$routes->post('guru/listdata', 'Home::guru_listData');
$routes->get('fasilitas', 'Home::fasilitas');
$routes->get('ekstrakurikuler', 'Home::ekstrakurikuler');
$routes->get('galeri', 'Home::galeri');

$routes->get('materi', 'Home::materi');
$routes->get('materi/lihat/(:num)', 'Home::lihat_materi/$1');
$routes->post('materi/listdata', 'Home::materi_listData');

$routes->get('berita', 'Home::berita');
$routes->post('berita/loadmore', 'Home::loadmore_berita');
$routes->get('berita/(:num)', 'Home::detail_berita/$1');

$routes->get('pengumuman', 'Home::pengumuman');
$routes->post('pengumuman/loadmore', 'Home::loadmore_pengumuman');
$routes->get('pengumuman/(:num)', 'Home::detail_pengumuman/$1');

$routes->post('kirim_pesan', 'Home::kirim_pesan');

// PPDB Publik
$routes->get('ppdb', 'Ppdb::index'); 
$routes->post('ppdb/save', 'Ppdb::save');

// PPDB Admin
$routes->get('admin/ppdb', 'Ppdb::adminIndex');          // List pendaftar
$routes->get('admin/ppdb/detail/(:num)', 'Ppdb::detail/$1'); // Detail per siswa
$routes->get('admin/ppdb/edit/(:num)', 'Ppdb::edit/$1');     // Edit form
$routes->post('admin/ppdb/update/(:num)', 'Ppdb::update/$1'); // Update data
$routes->get('admin/ppdb/approve/(:num)', 'Ppdb::approve/$1'); // Approve pendaftar
$routes->get('admin/ppdb/reject/(:num)', 'Ppdb::reject/$1');  // Reject pendaftar
$routes->get('admin/ppdb/delete/(:num)', 'Ppdb::delete/$1'); // Hapus data



// ========== ROUTE UNTUK ADMIN ==========
$routes->group('admin', [
    'filter'    => 'ceklogin',
    'namespace' => 'App\Controllers\Admin'
], function($routes)
{
   $routes->get('dashboard', 'Dashboard::index');

   
   // === PPDB ADMIN ===
   $routes->get('ppdb', '\App\Controllers\Ppdb::adminIndex'); 
   $routes->get('ppdb/edit/(:num)', '\App\Controllers\Ppdb::edit/$1');
   $routes->post('ppdb/update/(:num)', '\App\Controllers\Ppdb::update/$1');
   $routes->get('ppdb/delete/(:num)', '\App\Controllers\Ppdb::delete/$1');
   $routes->get('ppdb/exportExcel', '\App\Controllers\Ppdb::exportExcel');
   $routes->get('ppdb/exportPdf', '\App\Controllers\Ppdb::exportPdf');

   $routes->get('users', 'Users::index');
   $routes->get('users/new', 'Users::new');
   $routes->get('users/edit/(:num)', 'Users::edit/$1');
   $routes->post('users/create', 'Users::create');
   $routes->post('users/update/(:num)', 'Users::update/$1');
   $routes->delete('users/delete/(:num)', 'Users::delete/$1');

   $routes->get('kepsek', 'Kepsek::index');
   $routes->post('kepsek/update/(:num)', 'Kepsek::update/$1');

   $routes->get('guru', 'Guru::index');
   $routes->post('guru/listdata', 'Guru::listData');
   $routes->get('guru/new', 'Guru::new');
   $routes->get('guru/edit/(:num)', 'Guru::edit/$1');
   $routes->post('guru/create', 'Guru::create');
   $routes->post('guru/update/(:num)', 'Guru::update/$1');
   $routes->delete('guru/delete/(:num)', 'Guru::delete/$1');

   $routes->get('tahunajaran', 'Tahunajaran::index');
   $routes->get('tahunajaran/new', 'Tahunajaran::new');
   $routes->get('tahunajaran/edit/(:num)', 'Tahunajaran::edit/$1');
   $routes->post('tahunajaran/create', 'Tahunajaran::create');
   $routes->post('tahunajaran/update/(:num)', 'Tahunajaran::update/$1');
   $routes->delete('tahunajaran/delete/(:num)', 'Tahunajaran::delete/$1');
   $routes->get('tahunajaran/active/(:num)', 'Tahunajaran::active/$1');

   $routes->get('siswa', 'Siswa::index');
   $routes->post('siswa/listdata', 'Siswa::listData');
   $routes->get('siswa/new', 'Siswa::new');
   $routes->get('siswa/edit/(:num)', 'Siswa::edit/$1');
   $routes->post('siswa/create', 'Siswa::create');
   $routes->post('siswa/update/(:num)', 'Siswa::update/$1');
   $routes->delete('siswa/delete/(:num)', 'Siswa::delete/$1');

   $routes->get('fasilitas', 'Fasilitas::index');
   $routes->get('fasilitas/new', 'Fasilitas::new');
   $routes->get('fasilitas/edit/(:num)', 'Fasilitas::edit/$1');
   $routes->post('fasilitas/create', 'Fasilitas::create');
   $routes->post('fasilitas/update/(:num)', 'Fasilitas::update/$1');
   $routes->delete('fasilitas/delete/(:num)', 'Fasilitas::delete/$1');

   $routes->get('artikel', 'Artikel::index');
   $routes->post('artikel/listdata', 'Artikel::listData');
   $routes->get('artikel/new', 'Artikel::new');
   $routes->get('artikel/edit/(:num)', 'Artikel::edit/$1');
   $routes->post('artikel/create', 'Artikel::create');
   $routes->post('artikel/update/(:num)', 'Artikel::update/$1');
   $routes->delete('artikel/delete/(:num)', 'Artikel::delete/$1');

   $routes->get('ekstrakurikuler', 'Ekstrakurikuler::index');
   $routes->get('ekstrakurikuler/new', 'Ekstrakurikuler::new');
   $routes->get('ekstrakurikuler/edit/(:num)', 'Ekstrakurikuler::edit/$1');
   $routes->post('ekstrakurikuler/create', 'Ekstrakurikuler::create');
   $routes->post('ekstrakurikuler/update/(:num)', 'Ekstrakurikuler::update/$1');
   $routes->delete('ekstrakurikuler/delete/(:num)', 'Ekstrakurikuler::delete/$1');

   $routes->get('pengaturanweb', 'Pengaturanweb::index');
   $routes->post('pengaturanweb/update/(:num)', 'Pengaturanweb::update/$1');

   $routes->get('galeri', 'Galeri::index');
   $routes->get('galeri/new', 'Galeri::new');
   $routes->get('galeri/edit/(:num)', 'Galeri::edit/$1');
   $routes->post('galeri/create', 'Galeri::create');
   $routes->post('galeri/update/(:num)', 'Galeri::update/$1');
   $routes->delete('galeri/delete/(:num)', 'Galeri::delete/$1');

   $routes->get('pengumuman', 'Pengumuman::index');
   $routes->post('pengumuman/listdata', 'Pengumuman::listData');
   $routes->get('pengumuman/new', 'Pengumuman::new');
   $routes->get('pengumuman/edit/(:num)', 'Pengumuman::edit/$1');
   $routes->post('pengumuman/create', 'Pengumuman::create');
   $routes->post('pengumuman/update/(:num)', 'Pengumuman::update/$1');
   $routes->delete('pengumuman/delete/(:num)', 'Pengumuman::delete/$1');

   $routes->get('kontak', 'Kontak::index');
   $routes->post('kontak/listdata', 'Kontak::listData');
   $routes->get('kontak/new', 'Kontak::new');
   $routes->get('kontak/edit/(:num)', 'Kontak::edit/$1');
   $routes->post('kontak/create', 'Kontak::create');
   $routes->post('kontak/update/(:num)', 'Kontak::update/$1');
   $routes->delete('kontak/delete/(:num)', 'Kontak::delete/$1');

   $routes->get('slideshow', 'Slideshow::index');
   $routes->get('slideshow/new', 'Slideshow::new');
   $routes->get('slideshow/edit/(:num)', 'Slideshow::edit/$1');
   $routes->post('slideshow/create', 'Slideshow::create');
   $routes->post('slideshow/update/(:num)', 'Slideshow::update/$1');
   $routes->delete('slideshow/delete/(:num)', 'Slideshow::delete/$1');
   $routes->get('slideshow/active/(:num)', 'Slideshow::active/$1');
});
