<?= $this->extend('layouts/theme-frontend') ?>
<?= $this->section('content-frontend') ?>

<div class="container mt-5 mb-5">
  <div class="card shadow">
    <div class="card-header bg-primary text-white">
      <h4>Formulir Pendaftaran Siswa Baru (PPDB)</h4>
    </div>
    <div class="card-body">
      <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          <?= session()->getFlashdata('success') ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      <?php endif; ?>
      
      <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          <?= session()->getFlashdata('error') ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      <?php endif; ?>

      <form action="<?= base_url('ppdb/save') ?>" method="post">
        <?= csrf_field() ?>

        <!-- DATA SISWA -->
        <h5 class="mb-3 text-primary">Data Siswa</h5>
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Nama Lengkap</label>
            <input type="text" name="nama_lengkap" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Nama Panggilan</label>
            <input type="text" name="nama_panggilan" class="form-control">
          </div>
        </div>
        <div class="mb-3">
          <label>Jenis Kelamin</label>
          <select name="jenis_kelamin" class="form-control" required>
            <option value="">-- Pilih --</option>
            <option value="Laki-laki">Laki-laki</option>
            <option value="Perempuan">Perempuan</option>
          </select>
        </div>
        <div class="mb-3">
          <label>Tempat, Tanggal Lahir</label>
          <input type="text" name="tempat_tgl_lahir" class="form-control">
        </div>
        <div class="mb-3">
          <label>Agama</label>
          <input type="text" name="agama" class="form-control">
        </div>
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Anak Nomor Ke</label>
            <input type="number" name="anak_nomor_ke" class="form-control">
          </div>
          <div class="col-md-6 mb-3">
            <label>Dari Berapa Bersaudara</label>
            <input type="number" name="banyak_saudara" class="form-control">
          </div>
        </div>
        <div class="mb-3">
          <label>Bahasa Sehari-hari</label>
          <input type="text" name="bahasa_sehari" class="form-control">
        </div>
        <div class="row">
          <div class="col-md-4 mb-3">
            <label>Berat Badan (kg)</label>
            <input type="number" name="berat_badan" class="form-control">
          </div>
          <div class="col-md-4 mb-3">
            <label>Tinggi Badan (cm)</label>
            <input type="number" name="tinggi_badan" class="form-control">
          </div>
          <div class="col-md-4 mb-3">
            <label>Umur Saat Daftar (tahun)</label>
            <input type="number" name="umur_saat_daftar" class="form-control">
          </div>
        </div>

        <!-- DATA ORANG TUA -->
        <h5 class="mt-4 mb-3 text-primary">Data Orang Tua</h5>
        <div class="mb-3">
          <label>Nama Ayah</label>
          <input type="text" name="nama_ayah" class="form-control">
        </div>
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Pendidikan Ayah</label>
            <input type="text" name="pendidikan_ayah" class="form-control">
          </div>
          <div class="col-md-6 mb-3">
            <label>Pekerjaan Ayah</label>
            <input type="text" name="pekerjaan_ayah" class="form-control">
          </div>
        </div>
        <div class="mb-3">
          <label>Nama Ibu</label>
          <input type="text" name="nama_ibu" class="form-control">
        </div>
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Pendidikan Ibu</label>
            <input type="text" name="pendidikan_ibu" class="form-control">
          </div>
          <div class="col-md-6 mb-3">
            <label>Pekerjaan Ibu</label>
            <input type="text" name="pekerjaan_ibu" class="form-control">
          </div>
        </div>

        <!-- DATA WALI -->
        <h5 class="mt-4 mb-3 text-primary">Data Wali</h5>
        <div class="mb-3">
          <label>Nama Wali</label>
          <input type="text" name="nama_wali" class="form-control">
        </div>
        <div class="row">
          <div class="col-md-4 mb-3">
            <label>Pendidikan Wali</label>
            <input type="text" name="pendidikan_wali" class="form-control">
          </div>
          <div class="col-md-4 mb-3">
            <label>Hubungan Wali</label>
            <input type="text" name="hubungan_wali" class="form-control">
          </div>
          <div class="col-md-4 mb-3">
            <label>Pekerjaan Wali</label>
            <input type="text" name="pekerjaan_wali" class="form-control">
          </div>
        </div>
        <div class="mb-3">
          <label>Alamat Lengkap Wali</label>
          <textarea name="alamat_wali" class="form-control" rows="3"></textarea>
        </div>
        <div class="mb-3">
          <label>No HP / WhatsApp</label>
          <input type="text" name="no_hp" class="form-control">
        </div>

        <!-- DATA TAMBAHAN -->
        <h5 class="mt-4 mb-3 text-primary">Data Tambahan</h5>
        <div class="mb-3">
          <label>Asal Mula Siswa</label>
          <select name="asal_mula" class="form-control" required>
            <option value="">-- Pilih --</option>
            <option value="Siswa Baru">Siswa Baru</option>
            <option value="Siswa Pindahan">Siswa Pindahan</option>
          </select>
        </div>
        <div class="mb-3">
          <label>Tanggal Mendaftar</label>
          <input type="date" name="tgl_daftar" class="form-control">
        </div>

        <button type="submit" class="btn btn-primary">Kirim Pendaftaran</button>
      </form>
    </div>
  </div>
</div>

<?= $this->endSection() ?>
