<?= $this->extend('layouts/theme-frontend') ?>
<?= $this->section('content-frontend') ?>

<div class="jumbotron-fluid p-4 bg-light">
   <div class="row">
      <div class="col-md-12">
         <h1 class="text-center display-2"><?= $title; ?></h1>
         <h4 class="text-center"></h4>
      </div>
   </div>
</div>

<div class="container">
   <div class="row mt-5">
      <div class="col-md-12">
         <h3 class="text-center">Daftar Guru & Staf</h3>
      </div>
   </div>
   <div class="row">
      <div class="col-md-12">
         <div class="table-responsive">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" id="csrfSecure" />
            <table class="table table-bordered table-striped" id="datatable" cellspacing="0" width="100%">
               <thead>
                  <tr>
                     <th width="100">No</th>
                     <th>Foto</th>
                     <th>NIP/NIK</th>
                     <th>Nama</th>
                     <th>Jabatan</th>
                  </tr>
               </thead>
            </table>
         </div>
      </div>
   </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('script') ?>
<script>
   $(document).ready(function() {
      $('[data-bs-toggle="tooltip"]').tooltip();
      var table = $('#datatable').on('draw.dt', function() {
         $('[data-bs-toggle="tooltip"]').tooltip();
      }).DataTable({
         "lengthMenu": [
            [10, 20, -1],
            [10, 20, "All"]
         ],
         'destroy': true,
         'responsive': true,
         'processing': true,
         'serverSide': true,
         'order': [],
         'ajax': {
            'url': '<?= base_url('guru/listdata'); ?>',
            'type': 'POST',
            "data": {
               <?= csrf_token() ?>: $('input[name=<?= csrf_token() ?>]').val(),
            },
            "data": function(data) {
               data.<?= csrf_token() ?> = $('input[name=<?= csrf_token() ?>]').val()
            },
            "dataSrc": function(response) {
               $('input[name=<?= csrf_token() ?>]').val(response.<?= csrf_token() ?>);
               return response.data;
            },
         },
         'columnDefs': [{
            'targets': [0], //sesuaikan kolom yang tidak mau di sort
            'orderable': false
         }, ],
      })

      $('.tooltip').not(this).tooltip('hide');
   })
</script>
<?= $this->endSection('script'); ?>