<?= $this->extend('layouts/theme-backend') ?>
<?= $this->section('content') ?>

<div class="container-fluid">
  <div class="print-header" style="display: none;">
    <h2 style="text-align: center; margin: 0; text-transform: uppercase;">LAPORAN DATA PENDAFTAR PPDB</h2>
    <p style="text-align: center; margin: 10px 0;">Tanggal Cetak: <?= date('d F Y') ?></p>
    <hr>
  </div>
  
  <!-- Header khusus untuk print -->
  <div class="print-header" style="display: none;">
    <h2>DATA PENDAFTAR SISWA BARU (PPDB)</h2>
    <p><?= $setting['nama_web'] ?? 'SEKOLAH' ?></p>
    <p>Tahun Ajaran <?= date('Y') ?>/<?= date('Y') + 1 ?></p>
    <hr style="border: 1px solid #000; margin: 10px 0;">
  </div>

  <h3>Data Pendaftar PPDB</h3>
  <button onclick="printData()" class="btn btn-info btn-sm no-print">
    <i class="fas fa-print"></i> Print Data
  </button>
  <table class="table table-bordered mt-3">
    <thead>
      <tr>
        <th>ID</th>
        <th>Nama Lengkap</th>
        <th>JK</th>
        <th>Tempat, Tgl Lahir</th>
        <th>Nama Ayah</th>
        <th>Nama Ibu</th>
        <th>Alamat</th>
        <th>No HP</th>
        <th>Agama</th>
        <th>Anak Ke-</th>
        <th>Tanggal Daftar</th>
        <th>Status</th>
        <th class="no-print">Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($pendaftar as $p): ?>
      <tr>
        <td><?= $p['id'] ?></td>
        <td><?= $p['nama_lengkap'] ?></td>
        <td><?= $p['jenis_kelamin'] == 'Laki-laki' ? 'L' : 'P' ?></td>
        <td><?= $p['tempat_tgl_lahir'] ?? '-' ?></td>
        <td><?= $p['nama_ayah'] ?? '-' ?></td>
        <td><?= $p['nama_ibu'] ?? '-' ?></td>
        <td><?= !empty($p['alamat_wali']) ? (strlen($p['alamat_wali']) > 30 ? substr($p['alamat_wali'], 0, 30) . '...' : $p['alamat_wali']) : '-' ?></td>
        <td><?= $p['no_hp'] ?></td>
        <td><?= $p['agama'] ?? '-' ?></td>
        <td><?= $p['anak_nomor_ke'] ?? '-' ?></td>
        <td><?= date('d/m/Y', strtotime($p['created_at'])) ?></td>
        <td>
          <?php if($p['status'] == 'Diterima'): ?>
            <span class="badge bg-success">Diterima</span>
          <?php elseif($p['status'] == 'Ditolak'): ?>
            <span class="badge bg-danger">Ditolak</span>
          <?php else: ?>
            <span class="badge bg-warning">Pending</span>
          <?php endif; ?>
        </td>
        <td class="no-print">
          <a href="<?= base_url('admin/ppdb/detail/'.$p['id']) ?>" class="btn btn-info btn-sm" title="Detail">
            <i class="fas fa-eye"></i>
          </a>
          <a href="<?= base_url('admin/ppdb/edit/'.$p['id']) ?>" class="btn btn-warning btn-sm" title="Edit">
            <i class="fas fa-edit"></i>
          </a>
          <a href="<?= base_url('admin/ppdb/delete/'.$p['id']) ?>" onclick="return confirm('Hapus data ini?')" class="btn btn-danger btn-sm" title="Hapus">
            <i class="fas fa-trash"></i>
          </a>
        </td>
      </tr>
      <?php endforeach ?>
    </tbody>
  </table>
  
  <div class="print-footer" style="display: none;">
    <hr style="margin-top: 30px;">
    <p style="font-size: 10px; margin: 10px 0;">
      Total Data: <?= count($pendaftar) ?> Pendaftar | 
      Dicetak pada: <?= date('d F Y, H:i') ?> WIB
    </p>
  </div>
</div>

<style>
@media print {
  /* Sembunyikan semua elemen yang tidak perlu saat print */
  .sidebar, .navbar, .no-print, .btn, button, .navbar-nav, .navbar-brand, 
  .offcanvas, .card-header, .breadcrumb, nav, footer, .alert {
    display: none !important;
  }
  
  /* Reset body dan html untuk print */
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    font-family: Arial, sans-serif !important;
    background: white !important;
    color: black !important;
    -webkit-print-color-adjust: exact !important;
  }
  
  /* Atur margin print untuk kertas F4 landscape */
  @page {
    margin: 0.5in 0.3in;
    size: 8.5in 13in landscape; /* F4 landscape: 13 x 8.5 inch */
  }
  
  /* Pastikan hanya content utama yang tampil */
  .container-fluid {
    max-width: 100% !important;
    width: 100% !important;
    margin: 0 !important;
    padding: 10px !important;
    background: white !important;
  }
  
  /* Pastikan tabel dan elemen penting terlihat */
  table, th, td, .print-header, .print-footer {
    display: table !important;
  }
  
  th, td {
    display: table-cell !important;
  }
  
  /* Sembunyikan judul halaman biasa */
  h3 {
    display: none !important;
  }
  
  /* Header khusus print */
  .print-header {
    display: block !important;
    text-align: center !important;
    margin-bottom: 15px !important;
    page-break-after: avoid !important;
  }
  
  .print-header h2 {
    font-size: 16px !important;
    font-weight: bold !important;
    margin: 0 0 5px 0 !important;
    text-transform: uppercase !important;
  }
  
  .print-header p {
    font-size: 12px !important;
    margin: 2px 0 !important;
  }
  
  /* Footer khusus print */
  .print-footer {
    display: block !important;
    margin-top: 15px !important;
    page-break-inside: avoid !important;
  }
  
  /* Styling tabel untuk F4 landscape dengan data lengkap */
  table {
    width: 100% !important;
    font-size: 9px !important;
    border-collapse: collapse !important;
    margin: 10px 0 !important;
    page-break-inside: auto !important;
    background: white !important;
    color: black !important;
  }
  
  th, td {
    border: 1px solid #000 !important;
    padding: 4px 3px !important;
    text-align: left !important;
    vertical-align: top !important;
    line-height: 1.3 !important;
    word-wrap: break-word !important;
    background: white !important;
    color: black !important;
  }
  
  th {
    background-color: #ddd !important;
    font-weight: bold !important;
    text-align: center !important;
    font-size: 8px !important;
    padding: 5px 3px !important;
    -webkit-print-color-adjust: exact !important;
  }
  
  /* Lebar kolom optimal untuk F4 landscape */
  th:nth-child(1), td:nth-child(1) { width: 3% !important; } /* ID */
  th:nth-child(2), td:nth-child(2) { width: 12% !important; } /* Nama */
  th:nth-child(3), td:nth-child(3) { width: 5% !important; } /* JK */
  th:nth-child(4), td:nth-child(4) { width: 12% !important; } /* TTL */
  th:nth-child(5), td:nth-child(5) { width: 10% !important; } /* Ayah */
  th:nth-child(6), td:nth-child(6) { width: 10% !important; } /* Ibu */
  th:nth-child(7), td:nth-child(7) { width: 15% !important; } /* Alamat */
  th:nth-child(8), td:nth-child(8) { width: 8% !important; } /* HP */
  th:nth-child(9), td:nth-child(9) { width: 8% !important; } /* Agama */
  th:nth-child(10), td:nth-child(10) { width: 5% !important; } /* Anak ke */
  th:nth-child(11), td:nth-child(11) { width: 7% !important; } /* Tgl Daftar */
  th:nth-child(12), td:nth-child(12) { width: 5% !important; } /* Status */
  
  /* Baris zebra untuk readability */
  tbody tr:nth-child(even) {
    background-color: #f8f8f8 !important;
  }
  
  /* Prevent page break inside table rows */
  tr {
    page-break-inside: avoid !important;
  }
}

/* Tombol print styling */
.btn-info {
  margin-bottom: 15px;
}
</style>

<script>
function printData() {
  window.print();
}
</script>

<?= $this->endSection() ?>
