<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EkstrakurikulerModel;

class Ekstrakurikuler extends BaseController
{
	protected $ekstraModel;
	
	public function __construct()
	{
		$this->ekstraModel = new EkstrakurikulerModel();
	}

	public function index()
	{
		if ($this->session->logged_in == true && $this->session->roles == 2) {
			return redirect()->to('/admin/dashboard');
		}
		
		return view('admin/ekstrakurikuler/index', [
			'title' => 'Ekstrakurikuler',
			'ekstrakurikuler' => $this->ekstraModel->findAll(),
		]);
	}

	public function new()
	{
		return view('admin/ekstrakurikuler/create', [
			'title' => 'Tambah Data Ekstrakurikuler',
			'validation' => $this->validation
		]);
	}

	public function create()
	{
		$rules = [
			'ekstrakurikuler' => [
				'rules'  => 'required',
				'errors' => []
			],
			'deskripsi' => [
				'rules'  => 'required',
				'errors' => []
			],
			'foto_ekstrakurikuler' => [
				'rules'  => 'uploaded[foto_ekstrakurikuler]|mime_in[foto_ekstrakurikuler,image/jpeg,image/pjpeg,image/png,image/x-png]|ext_in[foto_ekstrakurikuler,jpg,jpeg,png]',
				'errors' => []
			],
		];

		if (!$this->validate($rules)) {
			//render view with error validation message
			return redirect()->back()->withInput();
		}

		$foto = $this->request->getFile('foto_ekstrakurikuler');
		if ($foto->isValid()) {
			$name = $foto->getName();
			$newName = $foto->getRandomName();
			$foto->move('img/ekstrakurikuler', $newName);
		}
		$data = [
			'ekstrakurikuler' => $this->request->getPost('ekstrakurikuler'),
			'isi' => $this->request->getPost('deskripsi'),
			'foto_ekstrakurikuler' => $newName,
		];

		$this->ekstraModel->insert($data);
		$this->session->setFlashdata('success', 'Data Ekstrakurikuler Berhasil Ditambahkan.');
		return redirect()->to('/admin/ekstrakurikuler');
	}

	public function edit($id)
	{
		return view('admin/ekstrakurikuler/edit', [
			'title' => 'Edit Data Ekstrakurikuler',
			'ekstrakurikuler' => $this->ekstraModel->find($id),
			'validation' => $this->validation
		]);
	}

	public function update($id)
	{
		$foto = $this->request->getFile('foto_ekskul');
		if ($foto->isValid() && !$foto->hasMoved()) {
			$newName = $foto->getRandomName();
			$foto->move('img/ekskul', $newName);

			$fotoLama = $this->request->getPost('foto_ekskul_lama');
			if ($fotoLama && $fotoLama != 'default.jpg' && file_exists('img/ekskul/' . $fotoLama)) {
				unlink('img/ekskul/' . $fotoLama);
			}
		} else {
			$newName = $this->request->getPost('foto_ekskul_lama');
		}

		$data = [
			'nama_ekskul' => $this->request->getPost('nama_ekskul'),
			'deskripsi'   => $this->request->getPost('deskripsi'),
			'foto_ekskul' => $newName,
		];

		$this->ekskulModel->update($id, $data);
		session()->setFlashdata('success', 'Data ekskul berhasil diubah.');
		return redirect()->to('/admin/ekskul');
	}

	public function delete($id)
	{
		$ekskul = $this->ekskulModel->find($id);

		if ($ekskul && $ekskul['foto_ekskul'] != 'default.jpg' && file_exists('img/ekskul/' . $ekskul['foto_ekskul'])) {
			unlink('img/ekskul/' . $ekskul['foto_ekskul']);
		}

		$this->ekskulModel->delete($id);
		session()->setFlashdata('success', 'Data ekskul berhasil dihapus.');
		return redirect()->to('/admin/ekskul');
	}

	}
